# AI dla biznesu — minimalizuj koszty dzięki głębokiemu Q-learningowi
# Testowanie AI

# Instalowanie Keras
# conda install -c conda-forge keras

# Importowanie bibliotek i innych plików Pythona
import os
import numpy as np
import random as rn
from keras.models import load_model
import environment

# Ustawienie ziarna generatora losowego
os.environ['PYTHONHASHSEED'] = '0'
np.random.seed(42)
rn.seed(12345)

# USTAWIENIE PARAMETRÓW
number_actions = 5
direction_boundary = (number_actions - 1) / 2
temperature_step = 1.5

# ZBUDOWANIE ŚRODOWISKA PRZEZ PROSTE UTWORZENIE OBIEKTU KLASY ENVIRONMENT
env = environment.Environment(optimal_temperature = (18.0, 24.0), initial_month = 0, initial_number_users = 20, initial_rate_data = 30)

# ŁADOWANIE WSTĘPNIE WYSZKOLONEGO MÓZGU
model = load_model("model.h5")

# WYBÓR TRYBU
train = False

# URUCHOMIENIE ROCZNEJ SYMULACJI W TRYBIE WNIOSKOWANIA
env.train = train
current_state, _, _ = env.observe()
for timestep in range(0, 12 * 30 * 24 * 60):
    q_values = model.predict(current_state)
    action = np.argmax(q_values[0])
    if (action - direction_boundary < 0):
        direction = -1
    else:
        direction = 1
    energy_ai = abs(action - direction_boundary) * temperature_step
    next_state, reward, game_over = env.update_env(direction, energy_ai, int(timestep / (30 * 24 * 60)))
    current_state = next_state

# PREZENTACJA WYNIKÓW SZKOLENIA DLA KAŻDEJ EPOKI UCZENIA
print("\n")
print("Energia zużyta dla działającego AI: {:.0f}".format(env.total_energy_ai))
print("Energia zużyta bez działającego AI: {:.0f}".format(env.total_energy_noai))
print("ZAOSZCZĘDZONA ENERGIA: {:.0f} %".format((env.total_energy_noai - env.total_energy_ai) / env.total_energy_noai * 100)) 
